
/*******************************************************************************/
/*  
	This script produces Table A4
	Mongey, Pilossoph, and Weinberg: "Which Workers Bear the Burden of Social Distancing?"
	Journal of Economic Inequality 2021	
    --
	Alexander Weinberg
	February 16, 2021
*/
/*******************************************************************************/

// __________________________________________________
// Load LWFH* and HPP*
use "../Data/2_digit_pp_wfh_onet", clear
replace pp 				= round(pp, 0.01)
replace low_wfh 		= round(low_wfh, 0.01)

//________________________________________________________________
// Rank 2-digit OCC occupations 
rename tot_emp Employment

gsort -low_wfh
gen Least_WFH = _n

gsort -pp
gen Most_PP = _n

format Employment %11.0gc

sort Least_WFH
order occ_2digit Employment Least_WFH Most_PP
keep occ_2digit Employment Least_WFH Most_PP

export delimited "../Tables/tableA4.csv", replace

// end


